﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Sample
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {

        private const string AuthorId = "投稿者ID";
        private const string FirstManagerId = "第一管理者ID";
        private const string SecondManagerId = "第二管理者ID";

        public MainWindow()
        {
            InitializeComponent();
        }

        private void TestButton_Click(object sender, RoutedEventArgs e)
        {
            string LoginUserId = TestLoginID.Text;
            string ContentFirstApproverId = TestFirstApproverId.Text == "" ? null : TestFirstApproverId.Text;
            string ContentSecondApproverId = TestSecondApproverId.Text == "" ? null : TestSecondApproverId.Text;

            SetButtonControls(LoginUserId, ContentFirstApproverId, ContentSecondApproverId);
        }

        private void SetButtonControls(string loginUserId, string firstApproverId, string secondApproverId)
        {
            string firstId = FirstManagerId;
            string secondId = SecondManagerId;

            string[,] controlTable = new string[,] {
                //          0,      1,        2,      3,     4,      5,     6,      7,      8,     9
                // longUserID,  first,   second, Detail,  Edit, Delete, first, second, reject, error 
                {  AuthorId,     null,     null,   "on",  "on",  "on",   null,  null,  null,   null },
                {  AuthorId,  firstId,     null,   "on",  null,  null,   null,  null,  null,   null },
                {  AuthorId,     null, secondId,   null,  null,  null,   null,  null,  null,   "err"}, // ※
                {  AuthorId,  firstId, secondId,   "on",  null,  null,   null,  null,  null,   null },
                {   firstId,     null,     null,   "on",  null,  null,   "on",  null,  "on",   null },
                {   firstId,  firstId,     null,   "on",  null,  null,   null,  null,  null,   null },
                {   firstId,     null, secondId,   null,  null,  null,   null,  null,  null,   "err"}, // ※
                {   firstId,  firstId, secondId,   "on",  null,  null,   null,  null,  null,   null },
                {  secondId,     null,     null,   "on",  null,  null,   null,  null,  null,   null },
                {  secondId,  firstId,     null,   "on",  null,  null,   "on",  null,  "on",   null },
                {  secondId,     null, secondId,   null,  null,  null,   null,  null,  null,   "err"}, // ※
                {  secondId,  firstId, secondId,   "on",  null,  null,   null,  null,  null,   null },
            };

            for (int i = 0; i < controlTable.GetLength(0); i++) 
            {
                if (   loginUserId == controlTable[i, 0]
                    && firstApproverId == controlTable[i, 1] 
                    && secondApproverId == controlTable[i, 2] ) {


                        //　あり得ない状態の場合はエラー終了する
                        System.Diagnostics.Debug.Assert(controlTable[i, 9] == null);

                        //　状態に対応したコントロールの活性化を行う
                        btnDetail.IsEnabled = controlTable[i, 3] != null;
                        btnEdit.IsEnabled = controlTable[i, 4] != null;
                        btnDelete.IsEnabled = controlTable[i, 5] != null;
                        btnFirstApprove.IsEnabled = controlTable[i, 6] != null;
                        btnSecondApprove.IsEnabled = controlTable[i, 7] != null;
                        btnReject.IsEnabled = controlTable[i, 8] != null;
                        return;                
                
                }
            }
            // loginuseridが他人の場合および各Approveridが管理者と異なる時にここに来る
            btnDetail.IsEnabled = false;
            btnEdit.IsEnabled = false;
            btnDelete.IsEnabled = false;
            btnFirstApprove.IsEnabled = false;
            btnSecondApprove.IsEnabled = false;
            btnReject.IsEnabled = false;
        }



    }
}
